#!/bin/sh
# ---------------------------------------------------
# Start Script for the Network Data Model Editor
#
# Environment Variable Prerequisites
#
#   ORACLE_HOME     Oracle database installation home.
# ---------------------------------------------------

# Get required environment variables
if [ ! -r "$ORACLE_HOME"/lib/xmlparserv2.jar ]; then
  echo "Cannot find $ORACLE_HOME/lib/xmlparserv2.jar"
  echo "This file is needed to run this program"
  exit 1
fi

if [ ! -r "$ORACLE_HOME"/jdbc/lib/ojdbc5.jar ]; then
  echo "Cannot find $ORACLE_HOME/lib/ojdbc5.jar"
  echo "This file is needed to run this program"
  exit 1
fi

if [ ! -r "$ORACLE_HOME"/jdk/bin/java ]; then
  echo "Cannot find $ORACLE_HOME/jdk/bin/java"
  echo "This file is needed to run this program"
  exit 1
fi


JARS=.:$ORACLE_HOME/jdbc/lib/ojdbc5.jar:$ORACLE_HOME/lib/xmlparserv2.jar

# Set the locations for required jar files as appropriate.

JARS="$JARS":$ORACLE_HOME/md/jlib/sdoapi.jar
JARS="$JARS":$ORACLE_HOME/md/jlib/sdoutl.jar
JARS="$JARS":$ORACLE_HOME/md/jlib/sdotype.jar

JAVA_PARAMS="-Xms256M -Xmx256M"
EDITOR_CLASS=SDOToKMZ
PROG_ARGS="-host stadb28.us.oracle.com -sid sdo_4 -port 15217 -driver thin -ratio 1.0 -user scott -password tiger -logofile telelogo.png -files_path /scratch/rkothuri/view_storage/rkothuri_venkatm_sdo/sdo/demo/KMZ/examples/ "
   
exec $ORACLE_HOME/jdk/bin/java $JAVA_PARAMS -classpath "$JARS" $EDITOR_CLASS $PROG_ARGS









